<?php
/**
 * Plugin Name: Etch Carousel
 * Description: Loads Embla Carousel library for carousel components.
 * Version: 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

function etch_carousel_enqueue_scripts() {
    wp_enqueue_script(
        'embla-carousel',
        plugin_dir_url(__FILE__) . 'js/embla-carousel.umd.js',
        array(),
        '8.6.0',
        true
    );
}
add_action('wp_enqueue_scripts', 'etch_carousel_enqueue_scripts', 1);

function etch_carousel_add_defer($tag, $handle) {
    if ($handle === 'embla-carousel') {
        return str_replace(' src', ' defer src', $tag);
    }
    return $tag;
}
add_filter('script_loader_tag', 'etch_carousel_add_defer', 10, 2);
